#include <Wire.h>
#include <LiquidCrystal_I2C.h>
#include <DHT.h>

LiquidCrystal_I2C lcd(0x27, 16, 2);

#define DHTPIN 2
#define DHTTYPE DHT11

DHT dht(DHTPIN, DHTTYPE);

int R = 9, G = 10, B = 11;

void setColor(int r, int g, int b) {
  analogWrite(R, r);
  analogWrite(G, g);
  analogWrite(B, b);
}

void setup() {
  lcd.init();
  lcd.backlight();
  dht.begin();
  pinMode(R, OUTPUT);
  pinMode(G, OUTPUT);
  pinMode(B, OUTPUT);
}

void loop() {
  float t = dht.readTemperature();
  float h = dht.readHumidity();

  lcd.clear();
  lcd.setCursor(0, 0);
  lcd.print("Temp: "); lcd.print(t); lcd.print("C");
  lcd.setCursor(0, 1);
  lcd.print("Hum : "); lcd.print(h); lcd.print("%");

  if (t < 20) setColor(0, 0, 255);      // cold - blue  
  else if (t > 30) setColor(255, 0, 0); // hot - red  
  else setColor(0, 255, 0);             // ideal - green

  delay(1500);
}
